import 'dotenv/config';
import { serve } from '@hono/node-server';
import app from './backend/hono.js';

const port = process.env.PORT || 3000;

console.log('========================================');
console.log('  SocialStoryAI Backend Server');
console.log('========================================');
console.log(`Environment: ${process.env.NODE_ENV || 'development'}`);
console.log(`Port: ${port}`);
console.log('----------------------------------------');

serve({
  fetch: app.fetch,
  port: parseInt(port),
}, (info) => {
  console.log(`Server running on http://localhost:${info.port}`);
  console.log(`API endpoint: http://localhost:${info.port}/api/trpc`);
  console.log(`Health check: http://localhost:${info.port}/health`);
  console.log('========================================');
});
